% LSS/3e MATLAB
% Chapter B
% Ex. B.1
abs(-2+1j)
angle(-2+1j)*180/pi
% Ex. B.2
real(2*exp(1j*pi/3))
imag(2*exp(1j*pi/3))
2*exp(1j*pi/3)
% Ex. B.3
z1 = 3+4j; z2 = 2+3j;
z1*z2
z1 = 5*exp(1j*53.1*pi/180); z2 = sqrt(13)*exp(1j*56.3*pi/180);
abs(z1/z2)
angle(z1/z2)*180/pi
% Ex. B.6
C = abs(-3+4j)
theta = angle(-3+4j)*180/pi
% Ex. B.7
x1 = det([3 1 1;7 3 -1;1 1 1])/det([2 1 1;1 3 -1;1 1 1])
% Sec. B.7
z = -3-4j
z_real = real(z); z_imag = imag(z);
z_mag = sqrt(z_real^2 + z_imag^2)
z_mag = sqrt(z*conj(z))
z_mag = abs(z)
z_rad = angle(z)
z_deg = angle(z)*180/pi
z_rad = atan2(z_imag,z_real)
cos(1j)
log(-1)
k = 0:2:11
k = 11:-10/3:0
k = 0:11
k = 0:2; w = exp(1j*(pi/3 + 2*pi*k/3))
k = 0:99; w = exp(1j*(pi/100 + 2*pi*k/100));
w(5)
k(5)
w(98:100)
t = 0:0.2/500:0.2-0.2/500;
f = sin(2*pi*10*t+pi/6)
f(1)
plot(t,f);
xlabel('t'); ylabel('f(t)')
plot(real(w),imag(w),'o');
xlabel('Re(w)'); ylabel('Im(w)'); axis equal
g = exp(-10*t);
h = f.*g;
plot(t,f,'-k',t,h,':k');
xlabel('t'); ylabel('Amplitude');
legend('f(t)','h(t)');
r = [1 0 0]
A = [2 3;4 5;0 6]
c = r'
B = [c A]
B(1,2)
B(1:2,2:3)
B(2,:)
A = [1 -2 3;-sqrt(3) 1 -sqrt(5);3 -sqrt(7) 1]; y = [1;pi;exp(1)];
x = inv(A)*y
x1 = det([y,A(:,2:3)])/det(A)
alpha = (0:10);
t = (0:0.001:0.2)';
T = t*ones(1,11);
H = exp(-T*diag(alpha)).*sin(2*pi*10*T+pi/6);
plot(t,H); xlabel('t'); ylabel('h(t)');
[R,P,K] = residue(B,A)
[R,P,K] = residue([1 0 0 0 0 pi],[1 -sqrt(8) 0 sqrt(32) -4]); R.', P.', K
% Chapter 1
% Sec. 1.11
f = @(t) exp(-t).*cos(2*pi*t);
t = 0; f(t)
f(0)
t = (-2:2);
f(t)
plot(t,f(t));
xlabel('t'); ylabel('f(t)'); grid;
t = (-2:0.01:2);
plot(t,f(t));
xlabel('t'); ylabel('f(t)'); grid;
u = @(t) 1.0.*(t>=0);
t = (-2:2); plot(t,u(t));
xlabel('t'); ylabel('u(t)');
t = (-2:0.01:2);  plot(t,u(t));
xlabel('t'); ylabel('u(t)');
axis([-2 2 -0.1 1.1]);
p = @(t) 1.0.*((t>=0)&(t<1));
t = (-1:0.01:2); plot(t,p(t));
xlabel('t'); ylabel('p(t) = u(t)-u(t-1)');
axis([-1 2 -.1 1.1]);
g = @(t) f(t).*u(t);
t = (-2:0.01:2);
plot(t,g(2*t+1)); xlabel('t'); ylabel('g(2t+1)'); grid;
plot(t,g(-t+1)); xlabel('t'); ylabel('g(-t+1)'); grid;
plot(t,g(2*t+1)+g(-t+1)); xlabel('t'); ylabel('h(t)'); grid;
x = @(t) exp(-t).*((t>=0)&(t<1));
t = (0:0.01:1);
E_x = sum(x(t).*x(t)*0.01)
x_squared = @(t) x(t).*x(t);
E_x = quad(x_squared,0,1)
g_squared = @(t) g(t).*g(t);
t = (0:0.001:100);
E_g = sum(g_squared(t)*0.001)
E_g = quad(g_squared,0,100)
% Chapter 2
% Ex. 2.2
r = roots([1 4 3]).'
r = roots([1 4 4]).'
r = roots([1 4 40]).'
% Ex. 2.3
y_0 = dsolve('D2y+4*Dy+3*y=0','y(0)=3','Dy(0)=-7','t')
y_0 = dsolve('D2y+4*Dy+4*y=0','y(0)=3','Dy(0)=-7','t')
y_0 = dsolve('D2y+4*Dy+40*y=0','y(0)=3','Dy(0)=-7','t')
% Ex. 2.7
y_n = dsolve('D2y+3*Dy+2*y=0','y(0)=0','Dy(0)=1','t'); h = diff(y_n)
% Sec. 2.7
CH2MP1
lambda
% Modify CH2MP1 with C = [1e-9, 1e-6]
CH2MP1
lambda
lambda = CH2MP2([1e4, 1e4, 1e4],[1e-9, 1e-6])
lambda = CH2MP2([10322,9592,10115],[1.12e-9, 1.32e-6])
CH2MP3
CH2MP4
% Chapter 3
% Ex. 3.4
n = (0:8); x_a = @(n) (0.8).^n; x_b = @(n) (-0.8).^(n); 
x_c = @(n) (0.5).^n; x_d = @(n) (1.1).^n;   
subplot(2,2,1); stem(n,x_a(n),'k'); ylabel('x_a[n]'); xlabel('n');
subplot(2,2,2); stem(n,x_b(n),'k'); ylabel('x_b[n]'); xlabel('n');
subplot(2,2,3); stem(n,x_c(n),'k'); ylabel('x_c[n]'); xlabel('n');
subplot(2,2,4); stem(n,x_d(n),'k'); ylabel('x_d[n]'); xlabel('n');
% Ex. 3.5
n = (-30:30); x = @(n) cos(n*pi/12+pi/4);
clf; stem(n,x(n),'k'); ylabel('x[n]'); xlabel('n');
% Ex. 3.12
n = -2:5; y = [1,2,zeros(1,length(n)-2)]; x = [0,0,n(3:end)];
for k = 1:length(n)-2,
    y(k+2) = y(k+1)-0.24*y(k)+x(k+2)-2*x(k+1);
end
n,y
% Ex. 3.14
n = (-2:20)'; y = [1;2;zeros(length(n)-2,1)];
for k = 1:length(n)-2,
    y(k+2) = 1.56*y(k+1)-0.81*y(k);
end;
clf; stem(n,y,'k'); xlabel('n'); ylabel('y[n]'); axis([-2 20 -1.5 2.5]);
% Ex. 3.15
c = inv([(-3)^(-1) -1*(-3)^(-1);(-3)^(-2) -2*(-3)^(-2)])*[-1/3;-2/9]
% Ex. 3.16
gamma = roots([1 -1.56 0.81]);
c = inv([gamma(1)^(-1) gamma(2)^(-1);gamma(1)^(-2) gamma(2)^(-2)])*[2;1]
% Ex. 3.19
n = (0:19); delta = @(n) 1.0.*(n==0); 
a = [1 -0.6 -0.16]; b = [5 0 0];
h = filter(b,a,delta(n));
clf; stem(n,h,'k'); xlabel('n'); ylabel('h[n]');
% Ex. 3.22
n = (0:11); x = @(n) 4.^(-n).*(n>=0);
a = [1 0.5 -1]; b = [2 6 0]; y = filter(b,a,x(n));
clf; stem(n,y,'k'); xlabel('n'); ylabel('y[n]'); axis([-0.5 11.5 -20 25]);
% Ex. 3.25
x = [0 1 2 3 2 1]; g = [1 1 1 1 1 1];
n = (0:1:length(x)+length(g)-2);
c = conv(x,g);
clf; stem(n,c,'k'); xlabel('n'); ylabel('c[n]'); axis([-0.5 10.5 0 10]);
% Sec. 3.11
f = @(n) exp(-n/5).*cos(pi*n/5).*(n>=0);
n = (-10:10)';
stem(n,f(n),'k');
xlabel('n'); ylabel('f[n]');
subplot(2,1,1); stem(n,f(-2*n),'k'); ylabel('f[-2n]');
subplot(2,1,2); stem(n,f(-2*n+1),'k'); ylabel('f[-2n+1]'); xlabel('n');
b = [1 0 0]; a = [1 -1 1];
n = (0:30)'; delta = @(n) 1.0.*(n==0);
h = filter(b,a,delta(n));
clf; stem(n,h,'k'); axis([-.5 30.5 -1.1 1.1]);
xlabel('n'); ylabel('h[n]');
x = @(n) cos(2*pi*n/6).*(n>=0);
y = filter(b,a,x(n));
stem(n,y,'k'); xlabel('n'); ylabel('y[n]');
z_i = filtic(b,a,[1 2]);
y_0 = filter(b,a,zeros(size(n)),z_i);
stem(n,y_0,'k'); xlabel('n'); ylabel('y_{0} [n]');
axis([-0.5 30.5 -2.1 2.1]);
y_total = filter(b,a,x(n),z_i);
sum(abs(y_total-(y + y_0)))
conv([1 1 1 1],[1 1 1 1])
u = @(n) 1.0.*(n>=0); h = @(n) (cos(pi*n/3)+sin(pi*n/3)/sqrt(3)).*u(n);
y = conv(h(n),x(n));
stem([0:60],y,'k'); xlabel('n'); ylabel('y[n]');
stem(n,y(1:31),'k'); xlabel('n'); ylabel('y[n]');
% Chapter 4
% Ex. 4.4
num = [2 0 5]; den = [1 3 2];
[r, p, k] = residue(num,den)
num = [2 7 4]; den = [conv([1 1],conv([1 2],[1 2]))];
[r, p, k] = residue(num,den)
num = [8 21 19]; den = [conv([1 2],[1 1 7])];
[r, p, k]= residue(num,den)
ang = angle(r), mag = abs(r)
% Ex. 4.5
syms a b t; x_a = sin(a*t)+cos(b*t);
X_a = laplace(x_a)
X_a = collect(X_a)
syms a b s; X_b = (a*s^2)/(s^2+b^2);
x_b = ilaplace(X_b);
% Ex. 4.21
H = tf(1,1); K = 7; G = tf([0 0 K],[1 8 0]); Ha = feedback(G,H)
H = tf(1,1); K = 16; G = tf([0 0 K],[1 8 0]); Hb = feedback(G,H)
H = tf(1,1); K = 80; G = tf([0 0 K],[1 8 0]); Hc = feedback(G,H)
% Ex. 4.26
H = tf(1,1); K = 7; G = tf([K],conv([1 0],[1 8])); Ha = feedback(G,H);
H = tf(1,1); K = 16; G = tf([K],conv([1 0],[1 8])); Hb = feedback(G,H);
H = tf(1,1); K = 80; G = tf([K],conv([1 0],[1 8])); Hc = feedback(G,H);
clf; step(Ha,'k-',Hb,'k--',Hc,'k-.');
legend('K = 7','K = 16','K = 80','Location','best');
t = 0:.001:1.5; Hd = series(Hc,tf([1],[1 0])); 
step(Hd,'k-',t); title('Unit Ramp Response');
% Ex. 4.27
H = @(s) (s+0.1)./(s+5); omega = 0:.01:20;
subplot(1,2,1); plot(omega,abs(H(1j*omega)),'k-');
subplot(1,2,2); plot(omega,angle(H(1j*omega))*180/pi,'k-');
B = [1 0.1]; A = [1 5]; H = freqs(B,A,omega); omega = 0:.01:20;
subplot(1,2,1); plot(omega,abs(H),'k-');
subplot(1,2,2); plot(omega,angle(H)*180/pi,'k-');
% Ex. 4.30
bode(tf([10 1000],[1 2 100]),'k-');
% Ex. 4.31
f = (0:.01:150); omega0 = 2*pi*60; theta = 60*pi/180;
H = @(s) (s.^2+omega0^2)./(s.^2+2*omega0*cos(theta)*s+omega0^2);
plot(f,abs(H(1j*2*pi*f)),'k-');
xlabel('f [Hz]'); ylabel('|H(j2\pi f)|');
% Sec. 4.12
omega_c = 2*pi*3000; C = 1e-9; R = 1/sqrt(C^2*omega_c^2)
f = linspace(0,20000,200); Hmag_RC = abs(CH4MP1([1],[R*C 1],f*2*pi));
plot(f,abs(f*2*pi)<=omega_c,'k-',f,Hmag_RC,'k--'); 
axis([0 20000 -0.05 1.05]); xlabel('f [Hz]'); ylabel('|H(j2\pi f)|'); 
legend('Ideal','First-order RC','location','best');
R = sqrt(2^(1/10)-1)/(C*omega_c)
B = 1; A = poly(-1/(R*C)*ones(10,1));A = A/A(end);
Hmag_cascade = abs(CH4MP1(B,A,f*2*pi));
plot(f,abs(f*2*pi)<=omega_c,'k-',f,Hmag_cascade,'k--'); 
axis([0 20000 -0.05 1.05]); xlabel('f [Hz]'); ylabel('|H(j2\pi f)|'); 
legend('Ideal','Tenth-order RC cascade','location','best');
N=10; poles = roots([(1j*omega_c)^(-2*N),zeros(1,2*N-1),1]);
BW_poles = poles(find(real(poles)<0));
A = poly(BW_poles); A = A/A(end); Hmag_BW = abs(CH4MP1(B,A,f*2*pi));
plot(f,abs(f*2*pi)<=omega_c,'k-',f,Hmag_BW,'k--'); 
axis([0 20000 -0.05 1.05]); xlabel('f [Hz]'); ylabel('|H(j2\pi f)|'); 
legend('Ideal','Tenth-order Butterworth','location','best');
CH4MP3(2)
CH4MP3(3)
omega_c = 2*pi*1000; R = 1; N = 8;
epsilon = sqrt(10^(R/10)-1);
CN  = CH4MP3(N).*((1/(1j*omega_c)).^[N:-1:0]);
CP = epsilon^2*conv(CN,CN); CP(end) = CP(end)+1;
poles = roots(CP); i = find(real(poles)<0); C_poles = poles(i);
plot(real(C_poles),imag(C_poles),'kx'); axis equal;
axis(omega_c*[-1.1 1.1 -1.1 1.1]);
xlabel('Real'); ylabel('Imaginary');
A = poly(C_poles); B = A(end)/sqrt(1+epsilon^2);
omega = linspace(0,2*pi*2000,2001); H_C = CH4MP1(B,A,omega);
plot(omega/2/pi,abs(H_C),'k'); axis([0 2000 0 1.1]);
xlabel('f [Hz]'); ylabel('|H_C(j2\pi f)|');
k = [1:N]; xi = 1/N*asinh(1/epsilon); phi = (k*2-1)/(2*N)*pi;
C_poles = omega_c*(-sinh(xi)*sin(phi)+1j*cosh(xi)*cos(phi));
plot(real(C_poles),imag(C_poles),'kx'); axis equal;
axis(omega_c*[-1.1 1.1 -1.1 1.1]);
xlabel('Real'); ylabel('Imaginary');
% Chapter 5
% Ex. 5.10
Omega = linspace(-pi,pi,400); H = @(z) z./(z-0.8);
subplot(1,2,1); plot(Omega,abs(H(exp(1j*Omega))),'k'); axis tight;
xlabel('\Omega'); ylabel('|H[e^{j \Omega}]|');
subplot(1,2,2); plot(Omega,angle(H(exp(1j*Omega)))*180/pi,'k'); axis tight;
xlabel('\Omega'); ylabel('\angle H[e^{j \Omega}] [deg]');
% Ex. 5.14
Omega = linspace(0,pi,400); 
H = @(z,gamma_m) (z.^2-1)./(z.^2-sqrt(2)*gamma_m*z+gamma_m^2);
plot(Omega,abs(H(exp(1j*Omega),0.83)),...
    Omega,abs(H(exp(1j*Omega),0.96)),...
    Omega,abs(H(exp(1j*Omega),0.99))); 
text(.27*pi,35,'|\gamma|=1'); 
text(.28*pi,25.5,'|\gamma|=0.96');
text(.35*pi,6.41,'|\gamma|=0.83'); 
set(gca,'xtick',0:pi/4:pi,'ytick',[0 6.41,25.5]);
axis([0 pi 0 40]); xlabel('\Omega'); ylabel('|H[e^{j \Omega}]|');
% Ex. 5.16
omegac = 10^5; Ba = [omegac]; Aa = [1 omegac]; Fs = 10^6/pi;
[B,A] = impinvar(Ba,Aa,Fs)
% Sec. 5.10
omega_c = 2*pi*3000; N=10;
poles = roots([(1j*omega_c)^(-2*N),zeros(1,2*N-1),1]);
poles = poles(find(poles<0));
B = 1; A = poly(poles); A = A/A(end);
Omega = linspace(0,pi,200); T = 1/10000; Omega_c = omega_c*T;
[B1,A1] = CH5MP3(B,A,T); % First-order backward difference transformation
[B2,A2] = CH5MP4(B,A,T); % Bilinear transformation
[B3,A3] = CH5MP4(B,A,2/omega_c*tan(Omega_c/2)); % Bilinear with prewarping
H1mag = abs(CH5MP1(B1,A1,Omega));
H2mag = abs(CH5MP1(B2,A2,Omega));
H3mag = abs(CH5MP1(B3,A3,Omega));
plot(Omega,(Omega<=Omega_c),'k',Omega,H1mag,'k-.',...
     Omega,H2mag,'k--',Omega,H3mag,'k:');
axis([0 pi -.05 1.05]);
xlabel('\Omega [rad]'); ylabel('Magnitude Response');
legend('Ideal','FOBD','BLT','Prewarp BLT','location','best');
roots([1 4 6 4 1])'
CH5MP2(B3,A3)
CH5MP5
% Chapter 6
% Ex. 6.1
n = 0:10; theta_n = atan(-4*n);
C_n(n==0) = 0.504; C_n(n~=0) = 0.504*2./sqrt(1+16*n(n~=0).^2);
subplot(1,2,1); stem(n,C_n,'.k'); axis([-.5 10.5 0 .6])
xlabel('n'); ylabel('C_n');
subplot(1,2,2); stem(n,theta_n,'.k'); axis([-.5 10.5 -1.6 0])
xlabel('n'); ylabel('\theta_n');
% Ex. 6.5
x = @(t) 1.0*(mod(t+pi/2,2*pi)<=pi);
t = linspace(-2*pi,2*pi,10001);
x19 = 0.5*ones(size(t));
for n=1:19, x19 = x19+2/(pi*n)*sin(pi*n/2)*cos(n*t); end
plot(t,x19,'k-'); axis([-2*pi 2*pi -0.2 1.2]);
xlabel('t'); ylabel('x_{19}(t)');
% Ex. 6.7
clf; n = (-5:5); D_n = 0.504./(1+4j*n);
subplot(1,2,1); stem(n,abs(D_n),'.k'); 
xlabel('n'); ylabel('|D_n|');
subplot(1,2,2); stem(n,angle(D_n),'.k'); 
xlabel('n'); ylabel('\angle D_n [rad]');
% Ex. 6.11
A = 1; D = @(n) -A*4j*sin(n*pi/2)./(n.^2*pi^2);
T0 = 2; omega0 = 2*pi/T0; t = (-T0:.001:T0);
D0 = 0; x10 = D0*ones(size(t));
for n = 1:10,
    x10 = x10+real(D(n)*exp(1j*omega0*n*t)+D(-n)*exp(-1j*omega0*n*t));
end
plot(t,x10,'k'); xlabel('t'); ylabel('x_{10}(t)');
% Ex. 6.16
T_0 = pi; N_0 = 256; T = T_0/N_0; t = (0:T:T*(N_0-1))';
x = exp(-t/2); x(1) = (exp(-pi/2)+1)/2;
D_n = fft(x)/N_0; n = [-N_0/2:N_0/2-1]';
clf; subplot(1,2,1); stem(n,abs(fftshift(D_n)),'.k');
axis([-5 5 0 .6]); xlabel('n'); ylabel('|D_n|');
subplot(1,2,2); stem(n,angle(fftshift(D_n)),'.k');
axis([-5 5 -2 2]); xlabel('n'); ylabel('\angle D_n [rad]');
% Sec. 6.7
x = @(t,A) mod(t,2*pi)/A.*(mod(t,2*pi)<A)+((mod(t,2*pi)>=A)&(mod(t,2*pi)<pi));
A = pi/2; [x_20,t] = CH6MP1(A,20);
plot(t,x_20,'k',t,x(t,A),'k:'); axis([-pi/4,2*pi+pi/4,-0.1,1.1]);
xlabel('t'); ylabel('x_{20}(t)');
[x_100,t] = CH6MP1(A,100);
plot(t,x_100,'k',t,x(t,A),'k:'); axis([-pi/4,2*pi+pi/4,-0.1,1.1]);
xlabel('t'); ylabel('x_{100}(t)');
A = pi/64; [x_20,t] = CH6MP1(A,20);
plot(t,x_20,'k',t,x(t,A),'k:'); axis([-pi/4,2*pi+pi/4,-0.1,1.1]);
xlabel('t'); ylabel('x_{20}(t)');
[x_100,t] = CH6MP1(A,100);
plot(t,x_100,'k',t,x(t,A),'k:'); axis([-pi/4,2*pi+pi/4,-0.1,1.1]);
xlabel('t'); ylabel('x_{100}(t)');
m = @(theta,t,omega) sum(cos(omega*t+theta*ones(size(t))));
N = 20; omega = 2*pi*100*[1:N]'; theta = zeros(size(omega));
t = linspace(-0.01,0.01,10000);
plot(t,m(theta,t,omega),'k'); xlabel('t [sec]'); ylabel('m(t) [volts]');
rng(0); theta_rand0 = 2*pi*rand(N,1);
m_rand0 = m(theta_rand0,t,omega);
plot(t,m_rand0,'k'); axis([-0.01,0.01,-10,10]);
xlabel('t [sec]'); ylabel('m(t) [volts]');
set(gca,'ytick',[min(m_rand0),max(m_rand0)]); grid on;
rng(5); theta_rand5 = 2*pi*rand(N,1);
m_rand5 = m(theta_rand5,t,omega);
plot(t,m_rand5,'k'); axis([-0.01,0.01,-10,10]);
xlabel('t [sec]'); ylabel('m(t) [volts]');
set(gca,'ytick',[min(m_rand5),max(m_rand5)]); grid on;
maxmagm = @(theta,t,omega) max(abs(sum(cos(omega*t+theta*ones(size(t))))));
t = linspace(0,0.01,401);
rng(0); theta_init = 2*pi*rand(N,1);
theta_opt = fminsearch(maxmagm,theta_init,[],t,omega);
t = linspace(-0.01,0.01,10000);
m_opt = m(theta_opt,t,omega);
plot(t,m_opt,'k'); axis([-0.01,0.01,-10,10]);
xlabel('t [sec]'); ylabel('m(t) [volts]');
set(gca,'ytick',[min(m_opt),max(m_opt)]); grid on;
Fs = 8000; t = [0:1/Fs:2];      % Two second records at a sampling rate of 8kHz
sound(m(theta,t,omega)/20,Fs);  % Play (scaled) m(t) constructed using zero phases
% Chapter 7
% Ex. 7.17
tau = 1; X = @(omega) tau/2*(sinc(omega*tau/(4*pi))).^2;
T0 = 2; omega0 = 2*pi/T0; D = @(n) X(n*omega0)/T0;
t = (-T0:.001:T0); x25 = D(0)*ones(size(t));
for n = 1:25,
    x25 = x25+real(D(n)*exp(1j*omega0*n*t)+D(-n)*exp(-1j*omega0*n*t));
end
plot(t,x25,'k'); xlabel('t'); ylabel('x_{25}(t)'); axis([-2 2 -.1 1.1]);
% Sec. 7.9
X = @(omega,tau) tau*CH7MP1(omega*tau/2);
omega = linspace(-4*pi,4*pi,1001);
plot(omega,X(omega,1),'k-',omega,X(omega,0.5),'k-.',omega,X(omega,2),'k--');
grid; axis tight; xlabel('\omega'); ylabel('X(\omega)');
legend('\tau = 1','\tau = 0.5','\tau = 2.0)','Location','Best');
X_squared = @(omega, tau) (tau*CH7MP1(omega*tau/2)).^2;
quad(X_squared,-1e6,1e6,[],[],1)
D = @(n,tau,T_0) tau/T_0*CH7MP1(n*pi*tau/T_0);
tau = pi; T_0 = 2*pi; n = [0:10];
stem(n,D(n,tau,T_0),'k.'); xlabel('n'); ylabel('D_n'); axis tight;
T_0 = 4*pi; n = [0:20];
stem(n,D(n,tau,T_0),'k.'); xlabel('n'); ylabel('D_n'); axis tight;
T_0 = 40*pi; n = [0:200];
stem(n,D(n,tau,T_0),'k.'); xlabel('n'); ylabel('D_n'); axis tight;
t = [-0.6:.001:0.6]; T = 1;
plot(t,CH7MP3(t,T,'r'),'k-',t,CH7MP3(t,T,'ham'),'k-.',t,CH7MP3(t,T,'b'),'k--');
axis([-0.6 0.6 -.1 1.1]); xlabel('t'); ylabel('w_K(t)');
legend('Rectangular','Hamming','Blackman','Location','EastOutside');
% Chapter 8
% Ex. 8.8
T_0 = 4; N_0 = 256; T = T_0/N_0; t = (0:T:T*(N_0-1))';
x = T*exp(-2*t); x(1) = x(1)/2;
X_r = fft(x); r = [-N_0/2:N_0/2-1]'; omega_r = r*2*pi/T_0;
omega = linspace(-pi/T,pi/T,5001); X = 1./(j*omega+2);
subplot(1,2,1); stem(omega_r,fftshift(abs(X_r)),'k.'); 
line(omega,abs(X),'color',[0 0 0]); axis([-0.01 44 -0.01 0.51]);
xlabel('\omega'); ylabel('|X(\omega)|');
subplot(1,2,2); stem(omega_r,fftshift(angle(X_r)),'k.'); 
line(omega,angle(X),'color',[0 0 0]); axis([-0.01 44 -pi/2-0.01 0.01]);
xlabel('\omega'); ylabel('\angle X(\omega)');
% Ex. 8.9
T_0 = 4; N_0 = 32; T = T_0/N_0;
x_n = [ones(1,4) 0.5 zeros(1,23) 0.5 ones(1,3)]';
X_r = fft(x_n); r = [-N_0/2:N_0/2-1]'; omega_r = r*2*pi/T_0;
omega = linspace(-pi/T,pi/T,5001); X = 8*sinc(omega/(2*pi));
clf; stem(omega_r,fftshift(real(X_r)),'k.'); 
line(omega,X,'color',[0 0 0]); 
xlabel('\omega'); ylabel('X(\omega)'); axis tight
% Ex. 8.10
T_0 = 4; N_0 = 32; T = T_0/N_0; n = (0:N_0-1); r = n;
x_n = [ones(1,4) 0.5 zeros(1,23) 0.5 ones(1,3)]'; X_r = fft(x_n);
H_r = [ones(1,8) 0.5 zeros(1,15) 0.5 ones(1,7)]';
Y_r = H_r.*X_r; y_n = ifft(Y_r);
clf; stem(n,real(y_n),'k.');
xlabel('n'); ylabel('y_n'); axis([0 31 -.1 1.1]);
% Section 8.7
T = 1/50; N_0 = 50; n = (0:N_0-1);
x = T*cos(2*pi*10*n*T);
X = fft(x);
f = (0:N_0-1)/(T*N_0); stem(f,abs(X),'k.'); 
axis([0 50 -0.05 0.55]); xlabel('f [Hz]'); ylabel('|X(f)|');
stem(f-1/(T*2),fftshift(abs(X)),'k.'); 
axis([-25 25 -0.05 0.55]); xlabel('f [Hz]'); ylabel('|X(f)|');
stem(f-1/(T*2),fftshift(angle(X)),'k.'); 
axis([-25 25 -1.1*pi 1.1*pi]); xlabel('f [Hz]'); ylabel('\angle X(f)');
y = T*exp(j*2*pi*(10+1/3)*n*T); Y = fft(y);
stem(f-25,fftshift(abs(Y)),'k.'); 
axis([-25 25 -0.05 1.05]); xlabel('f [Hz]'); ylabel('|Y(f)|');
y_zp = [y,zeros(1,11*length(y))]; Y_zp = fft(y_zp);
f_zp = (0:12*N_0-1)/(T*12*N_0);
stem(f_zp-25,fftshift(abs(Y_zp)),'k.'); 
axis([5 15 -0.05 1.05]); xlabel('f [Hz]'); ylabel('|Y_{zp}(f)|');
x = (-10:.0001:10); xsq = CH8MP1(x,10,3,'sym');
plot(x,xsq,'k'); axis([-10 10 -10.5 10.5]); grid on;
xlabel('Quantizer input'); ylabel('Quantizer output');
x = (-10:.0001:10); xsq = CH8MP1(x,10,3,'asym');
plot(x,xsq,'k'); axis([-10 10 -10.5 10.5]); grid on;
xlabel('Quantizer input'); ylabel('Quantizer output');
T = 1/50; N_0 = 50; n = (0:N_0-1); f = (0:N_0-1)/(T*N_0);
x = cos(2*pi*n*T); X = fft(x);  
xaq = CH8MP1(x,1,2,'asym'); Xaq = fft(xaq);
subplot(2,2,1); stem(n,x,'k.'); axis([0 49 -1.1 1.1]);
xlabel('n');ylabel('x[n]');
subplot(2,2,2); stem(f-25,fftshift(abs(X)),'k.'); axis([-25,25 -1 26])
xlabel('f');ylabel('|X(f)|');
subplot(2,2,3); stem(n,xaq,'k.');axis([0 49 -1.1 1.1]);
xlabel('n');ylabel('x_{aq}[n]');
subplot(2,2,4); stem(f-25,fftshift(abs(fft(xaq))),'k.'); axis([-25,25 -1 26]);
xlabel('f');ylabel('|X_{aq}(f)|');
% Chapter 9
% Ex. 9.2
N_0 = 32; n = (0:N_0-1); Omega_0 = 2*pi/N_0;
x_n = [ones(1,5) zeros(1,23) ones(1,4)];
for r = 0:N_0-1,
    X_r(r+1) = sum(x_n.*exp(-j*r*Omega_0*n))/N_0;
end
r = n; stem(r,real(X_r),'k.');
xlabel('r'); ylabel('X_r'); axis([0 31 -.1 0.3]);
X_r = fft(x_n)/N_0; stem(r,real(X_r),'k.');
xlabel('r'); ylabel('X_r'); axis([0 31 -.1 0.3]);
% Ex. 9.5
Omega = linspace(0,2*pi,1000); 
X = sin(4.5*Omega)./sin(0.5*Omega); X(mod(Omega,2*pi)==0) = 4.5/0.5;
N_0 = 64; M = 9; x = [ones(1,(M+1)/2) zeros(1,N_0-M) ones(1,(M-1)/2)];
Xr = fft(x); Omega_0 = 2*pi/N_0; r = 0:N_0-1;
plot(Omega,abs(X),'k-',Omega_0*r,abs(Xr),'k.'); axis([0 2*pi 0 9.5]);
xlabel('\Omega'); ylabel('|X(\Omega)|');
% Section 9.7
T = 1/1000; N_0 = 100; n = (0:N_0-1)';
x = cos(2*pi*50*n*T);
X = fft(x)/N_0; f = (0:N_0-1)/(T*N_0);
stem(f-1/(2*T),fftshift(abs(X)),'k.'); 
axis([-500 500 -0.05 0.55]); xlabel('f [Hz]'); ylabel('|X(f)|');
x = real(ifft(X)*N_0); stem(n,x,'k.'); 
axis([0 99 -1.1 1.1]); xlabel('n'); ylabel('x[n]');
W = @(N_0) (exp(-j*2*pi/N_0)).^((0:N_0-1)'*(0:N_0-1));
X = W(N_0)*x/N_0; stem(f-1/(2*T),fftshift(abs(X)),'k.');
axis([-500 500 -0.05 0.55]); xlabel('f [Hz]'); ylabel('|X(f)|');
tic; W(N_0)*x/N_0; toc
tic; for i=1:100, W(N_0)*x/N_0; end; toc
W100 = W(100); tic; for i=1:100, W100*x/N_0; end; toc
tic; for i=1:100, fft(x)/N_0; end; toc
x1 = rand(1015,1); tic; for i=1:100; fft(x1)/1015; end; T1 = toc
x2 = [x1;zeros(4,1)]; tic; for i=1:100; fft(x2)/1019; end; T2 = toc
x3 = [x2;zeros(5,1)]; tic; for i=1:100; fft(x3)/1024; end; T3 = toc
H_d = @(Omega) (mod(Omega,2*pi)<pi/4)+(mod(Omega,2*pi)>2*pi-pi/4);
N = 21; h = CH9MP1(N,H_d);
Omega = linspace(0,2*pi,1000); samples = linspace(0,2*pi*(1-1/N),N)';
H = CH5MP1(h,1,Omega);
subplot(2,1,1); stem([0:N-1],h,'k.'); xlabel('n'); ylabel('h[n]');
subplot(2,1,2);
plot(samples,H_d(samples),'k.',Omega,H_d(Omega),'k:',Omega,abs(H),'k');
axis([0 2*pi -0.1 1.6]); xlabel('\Omega'); ylabel('|H(\Omega)|');
legend('Samples','Desired','Actual','Location','North');
H_d = @(Omega) (mod(Omega,2*pi)<pi/4)+(mod(Omega,2*pi)>2*pi-pi/4);
N = 21; h = CH9MP2(N,H_d);
Omega = linspace(0,2*pi,1000); samples = linspace(0,2*pi*(1-1/N),N)';
H = CH5MP1(h,1,Omega);
subplot(2,1,1); stem([0:N-1],h,'k.'); xlabel('n'); ylabel('h[n]');
subplot(2,1,2);
plot(samples,H_d(samples),'k.',Omega,H_d(Omega),'k:',Omega,abs(H),'k');
axis([0 2*pi -0.1 1.6]); xlabel('\Omega'); ylabel('|H(\Omega)|');
legend('Samples','Desired','Actual','Location','North');
H_d = @(Omega) (mod(Omega,2*pi)>pi/4)&(mod(Omega,2*pi)<pi/2)+...
      (mod(Omega,2*pi)>3*pi/2)&(mod(Omega,2*pi)<7*pi/4);
N = 50; h = CH9MP2(N,H_d);
Omega = linspace(0,2*pi,1000); samples = linspace(0,2*pi*(1-1/N),N)';
H = CH5MP1(h,1,Omega); subplot(2,1,1); stem([0:N-1],h,'k.'); 
xlabel('n'); ylabel('h[n]'); axis([0 50 -.25 .25]);
subplot(2,1,2);
plot(samples,H_d(samples),'k.',Omega,H_d(Omega),'k:',Omega,abs(H),'k');
axis([0 2*pi -0.1 1.6]); xlabel('\Omega'); ylabel('|H(\Omega)|');
legend('Samples','Desired','Actual','Location','North');
% Chapter 10
% Ex. 10.5
num = [2 10]; den = [1 8 19 12];
[A,B,C,D] = tf2ss(num,den)
[num,den] = ss2tf(A,B,C,D); H = tf(num,den)
% Ex. 10.6
syms s
A = [-12 2/3;-36 -1]; B = [1/3; 1]; q0 = [2;1]; X = 1/s;
q = ilaplace(inv(s*eye(2)-A)*(q0+B*X))
t = (0:.01:2); q = subs(q); q1 = q(1,:); q2 = q(2,:);
plot(t,q1,'k',t,q2,'k--'); xlabel('t'); ylabel('Amplitude');
legend('q_1(t)','q_2(t)','Location','SE');
% Ex. 10.7
A = [0 1;-2 -3]; B = [1 0;1 1];
C = [1 0;1 1;0 2]; D = [0 0;1 0;0 1];
syms s; H = collect(simplify(C*inv(s*eye(2)-A)*B+D))
[num,den] = ss2tf(A,B,C,D,2); H_32 = tf(num(3,:),den)
% Ex. 10.10
A = [0 1;-2 -3]; B = [1; 2];
P = [1 1;1 -1];
Ahat = P*A*inv(P), Bhat = P*B
% Ex. 10.11
A = [0 1;-2 -3]; B = [1; 2];
[V, Lambda] = eig(A);
P = inv(V), Lambda, Bhat = P*B
% Ex. 10.12
A = [1 0;1 -1]; B = [1; 0]; C = [1 -2];
[V, Lambda] = eig(A); P=inv(V); Bhat = P*B, Chat = C*inv(P)
A = [-1 0;-2 1]; B = [1; 1]; C = [0 1];
[V, Lambda] = eig(A); P=inv(V); Bhat = P*B, Chat = C*inv(P)
% Ex. 10.13
A = [0 1;-1/6 5/6]; B = [0; 1]; C = [-1 5]; D = 0;
N = 25; n = (0:N); x = ones(1,N+1); q0 = [2;3];
sys = ss(A,B,C,D,-1); % Discrete-time state space model
[y,q] = lsim(sys,x,n,q0); % Simulate output and state vector
clf; stem(n,y,'k.'); xlabel('n'); ylabel('y[n]'); axis([-.5 25.5 11.5 13.5]);
% Section 10.8
A = [0 1;-1/6 5/6]; B = [0; 1]; C = [-1 5]; D = 0;
q_0 = [2;3];
z = sym('z');
X = ztrans(sym('1'))
Q = inv(eye(2)-z^(-1)*A)*q_0 + inv(z*eye(2)-A)*B*X
Q = simplify(Q)
Y = simplify(C*Q)
y = iztrans(Y)
y_zir = iztrans(simplify(C*inv(eye(2)-z^(-1)*A)*q_0))
y_zsr = y - y_zir
iztrans(simplify(C*inv(z*eye(2)-A)*B*X))
n = [0:25]; stem(n,subs(y,n),'k.'); 
xlabel('n'); ylabel('y[n]'); axis([-.5 25.5 11.5 13.5]);
H = collect(simplify(C*inv(z*eye(2)-A)*B+D))
[num,den] = ss2tf(A,B,C,D)
syms gamma; char_poly = subs(det(z*eye(2)-A),z,gamma)
roots(sym2poly(char_poly))
h = iztrans(H)
iztrans(z^(-2)*X)
y_zsr = iztrans(H*X)
A = [0 1;-1/6 -5/6]; B = [0; 1]; C = [-1/6 -1/3]; D = 1;
[V,Lambda] = eig(A)
P = inv(V);
Ahat = P*A*inv(P), Bhat = P*B, Chat = C*inv(P)
A = [0 -1/6;1 -5/6]; B = [-1/6; -1/3]; C = [0 1]; D = 1;
[V,Lambda] = eig(A)
P = inv(V);
Ahat = P*A*inv(P), Bhat = P*B, Chat = C*inv(P)
A = [0 1;-1/6 5/6]; n = 3; A^n
A*A*A
syms z n; An = simplify(iztrans(inv(eye(2)-z^(-1)*A)))
double(subs(An,n,3))
syms t; A = [-12 2/3;-36 -1]; eAt = simplify(expm(A*t))
syms s; simplify(ilaplace(inv(s*eye(2)-A)))
double(subs(eAt,t,3))
expm(A*3)