function [h] = CH9MP2(N,H_d);
% CH9MP2.m : Chapter 9, MATLAB Program 2
% Function M-file designs a length-N FIR filter by sampling the desired
% magnitude response H_d.  Phase is defined to shift h[n] by (N-1)/2.
% INPUTS:   N = desired FIR filter length
%           H_d = anonymous function that defines the desired magnitude response
% OUTPUTS:  h = impulse response (FIR filter coefficients)

% Create N equally spaced frequency samples and use to sample H_d:
Omega = linspace(0,2*pi*(1-1/N),N)'; H = H_d(Omega);
% Define phase to shift h[n] by (N-1)/2:
H = H.*exp(-j*Omega*((N-1)/2));
H(fix(N/2)+2:N,1) = H(fix(N/2)+2:N,1)*((-1)^(N-1));
h = real(ifft(H));