function [h] = CH9MP1(N,H_d);
% CH9MP1.m : Chapter 9, MATLAB Program 1
% Function M-file designs a length-N FIR filter by sampling the desired
% magnitude response H_d.  Phase response is left as zero.
% INPUTS:   N = desired FIR filter length
%           H_d = anonymous function that defines the desired magnitude response
% OUTPUTS:  h = impulse response (FIR filter coefficients)

% Create N equally spaced frequency samples:
Omega = linspace(0,2*pi*(1-1/N),N)';
% Sample the desired magnitude response and create h[n]:
H = 1.0*H_d(Omega); h = real(ifft(H));