function [W,E_W] = CH7MP2(tau,beta,tol)
% CH7MP2.m : Chapter 7, MATLAB Program 2
% Function M-file computes essential bandwidth W for square pulse.
% INPUTS:   tau = pulse width
%           beta = fraction of signal energy desired in W
%           tol = tolerance of relative energy error
% OUTPUTS:  W = essential bandwidth [rad/s]
%           E_W = Energy contained in bandwidth W
W = 0; step = 2*pi/tau;     % Initial guess and step values
X_squared = @(omega,tau) (tau*CH7MP1(omega*tau/2)).^2;
E = beta*tau;               % Desired energy in W
relerr = (E-0)/E;           % Initial relative error is 100 percent
while(abs(relerr) > tol),
    if (relerr>0),          % W too small, so...
        W=W+step;           % ... increase W by step
    elseif (relerr<0),      % W too large, so...
        step = step/2;      % ... decrease step and then W
        W = W-step;
    end
    E_W = 1/(2*pi)*quad(X_squared,-W,W,[],[],tau);
    relerr = (E - E_W)/E;
end
