function [xq] = CH8MP1(x,xmax,B,method)
% CH8MP1.m : Chapter 8, MATLAB Program 1
% Function M-file quantizes x over (-xmax,xmax) using 2^b levels.
% Uses rounding rule, supports symmetric and asymmetric quantization
% INPUTS:   x = input signal
%           xmax = maximum magnitude of signal to be quantized
%           B = number of quantization bits
%           method = default 'sym' for symmetrical, 'asym' for asymmetrical
% OUTPUTS:  xq = quantized signal
if (nargin<3),
    disp('Insufficient number of inputs.'); return
elseif (nargin==3),
    method = 'sym';
elseif (nargin>4),
    disp('Too many inputs.'); return
end

x(abs(x)>xmax)=xmax*sign(x(abs(x)>xmax));   % Limit amplitude to xmax       
switch lower(method)
    case 'asym'
        xq = xmax/(2^(B-1))*floor(x*2^(B-1)/xmax+1/2);
        xq(xq>=xmax)=xmax*(1-2^(1-B));      % Ensure only 2^B levels
    case 'sym'
        xq = xmax/(2^(B-1))*(floor(x*2^(B-1)/xmax)+1/2);
        xq(xq>=xmax)=xmax*(1-2^(1-B)/2);    % Ensure only 2^B levels
    otherwise
        disp('Unrecognized quantization method.'); return
end
