function [x_N,t] = CH6MP1(A,N);
% CH6MP1.m : Chapter 6, MATLAB Program 1
% Function M-file approximates x(t) using Fourier series truncated at |n|=N 
% INPUTS:   A = width of rising edge
%           N = largest harmonic of truncated Fourier series
% OUTPUTS:  x_N = Nth harmonic truncated Fourier series
%           t = time vector for x_N

% Define FS coefficients for signal x(t)
D = @(n) 1/(2*pi*n)*((exp(-1j*n*A)-1)/(n*A) + 1j*exp(-1j*n*pi));
% Construct truncated FS approximation of x(t) using N harmonics
t = linspace(-pi/4,2*pi+pi/4,10000);    % Time vector exceeds one period.
x_N = (2*pi-A)/(4*pi)*ones(size(t));    % Compute dc term
for n = 1:N,                            % Compute N remaining terms
    x_N = x_N+real(D(n)*exp(1j*n*t) + conj(D(n))*exp(-1j*n*t));
end
