function [H] = CH5MP1(B,A,Omega);
% CH5MP1.m : Chapter 5, MATLAB Program 1
% Function M-file computes frequency response for LTID systems
% INPUTS:   B = vector of feedforward coefficients
%           A = vector of feedback coefficients
%           Omega = vector of frequencies [rad], typically -pi<=Omega<=pi
% OUTPUTS:  H =  frequency response

N_1 = length(B)-1; N_2 = length(A)-1;
H = polyval(B,exp(1j*Omega))./polyval(A,exp(1j*Omega)).*...
    exp(1j*Omega*(N_2-N_1));
